/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.peer;

import com.aptana.editor.common.internal.peer.PeerCharacterCloser;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.swt.events.VerifyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExitPolicy
implements LinkedModeUI.IExitPolicy {
    private static final char CURLY_RIGHT_SINGLE_QUOTE = '\u2019';
    private static final char CURLY_RIGHT_DOUBLE_QUOTE = '\u201d';
    private ITextViewer fTextViewer;
    private final char fExitCharacter;
    private final char fEscapeCharacter;
    private final Stack<PeerCharacterCloser.BracketLevel> fStack;
    private final int fSize;

    public ExitPolicy(ITextViewer textViewer, char exitCharacter, char escapeCharacter, Stack<PeerCharacterCloser.BracketLevel> stack) {
        this.fTextViewer = textViewer;
        this.fExitCharacter = exitCharacter;
        this.fEscapeCharacter = escapeCharacter;
        this.fStack = stack;
        this.fSize = this.fStack != null ? this.fStack.size() : 0;
    }

    public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
        if (this.shouldInsertNewline() && (event.character == '\n' || event.character == '\r')) {
            return new LinkedModeUI.ExitFlags(1, true);
        }
        if (event.character != this.fExitCharacter) {
            return null;
        }
        if (this.fSize == this.fStack.size() && !this.isEscaped(offset)) {
            PeerCharacterCloser.BracketLevel level = this.fStack.peek();
            if (offset < level.fFirstPosition.offset || level.fSecondPosition.offset < offset) {
                return null;
            }
            if (level.fSecondPosition.offset == offset && length == 0) {
                return new LinkedModeUI.ExitFlags(2, false);
            }
        }
        return null;
    }

    private boolean shouldInsertNewline() {
        return !this.isStringPair() && this.fExitCharacter != '|' && this.fExitCharacter != '>';
    }

    private boolean isStringPair() {
        return this.fExitCharacter == '\"' || this.fExitCharacter == '\'' || this.fExitCharacter == '`' || this.fExitCharacter == '\u201d' || this.fExitCharacter == '\u2019';
    }

    private boolean isEscaped(int offset) {
        IDocument document = this.fTextViewer.getDocument();
        try {
            return this.fEscapeCharacter == document.getChar(offset - 1);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

